<?php
// bot.php
// IMPORTANT: Token and Admin ID are embedded as requested.
// SECURITY NOTE: If this token was exposed publicly, immediately regenerate it via BotFather.

define('BOT_TOKEN', '8019927469:AAF3OJ7uVkEI7Qi22PUuXcFFU0BGJ-rigx0');
define('ADMIN_ID', '8117740484');
define('MESSAGES_FILE', __DIR__ . '/messages.txt');
define('GROUPS_FILE', __DIR__ . '/groups.txt');
define('STATUS_FILE', __DIR__ . '/status.txt');
define('POINTER_FILE', __DIR__ . '/pointer.txt');

function sendMessage($chat_id, $text) {
    $url = "https://api.telegram.org/bot" . BOT_TOKEN . "/sendMessage";
    // Using @file_get_contents for simplicity; for production consider curl with error handling.
    file_get_contents($url . "?chat_id=" . $chat_id . "&text=" . urlencode($text));
}

$update = json_decode(file_get_contents("php://input"), true);
if (!$update || !isset($update['message'])) exit;
$msg = $update['message'];
$user_id = $msg['from']['id'];
$text = trim($msg['text'] ?? '');
$chat_id = $msg['chat']['id'];

if ($user_id != ADMIN_ID) {
    sendMessage($chat_id, "⛔ فقط ادمین اصلی می‌تواند از این ربات استفاده کند.");
    exit;
}

switch (true) {
    case preg_match('/^\/add (.+)/', $text, $m):
        $message = trim($m[1]);
        file_put_contents(MESSAGES_FILE, $message . PHP_EOL, FILE_APPEND);
        sendMessage($chat_id, "✅ پیام جدید اضافه شد:\n\n" . $message);
        break;

    case $text == '/list':
        if (!file_exists(MESSAGES_FILE)) {
            sendMessage($chat_id, "📭 هنوز پیامی ثبت نشده است.");
        } else {
            $lines = file(MESSAGES_FILE, FILE_IGNORE_NEW_LINES | FILE_SKIP_EMPTY_LINES);
            if (count($lines) == 0) {
                sendMessage($chat_id, "📭 لیست پیام‌ها خالی است.");
            } else {
                $out = "📋 پیام‌های فعلی:\n\n";
                foreach ($lines as $i => $l) $out .= ($i + 1) . ". " . $l . "\n";
                sendMessage($chat_id, $out);
            }
        }
        break;

    case preg_match('/^\/del (\d+)/', $text, $m):
        $num = intval($m[1]) - 1;
        $lines = file(MESSAGES_FILE, FILE_IGNORE_NEW_LINES | FILE_SKIP_EMPTY_LINES);
        if (isset($lines[$num])) {
            $removed = $lines[$num];
            unset($lines[$num]);
            file_put_contents(MESSAGES_FILE, implode(PHP_EOL, $lines) . PHP_EOL);
            sendMessage($chat_id, "🗑 پیام حذف شد:\n\n" . $removed);
        } else {
            sendMessage($chat_id, "❌ شماره پیام معتبر نیست.");
        }
        break;

    case preg_match('/^\/addgroup (-?\\d+)/', $text, $m):
        $gid = trim($m[1]);
        $existing = file_exists(GROUPS_FILE) ? file(GROUPS_FILE, FILE_IGNORE_NEW_LINES | FILE_SKIP_EMPTY_LINES) : [];
        if (in_array($gid, $existing)) {
            sendMessage($chat_id, "⚠️ این گروه از قبل ثبت شده است.");
        } else {
            file_put_contents(GROUPS_FILE, $gid . PHP_EOL, FILE_APPEND);
            sendMessage($chat_id, "✅ گروه جدید اضافه شد:\n" . $gid);
        }
        break;

    case $text == '/groups':
        if (!file_exists(GROUPS_FILE)) {
            sendMessage($chat_id, "📭 هنوز هیچ گروهی ثبت نشده است.");
        } else {
            $groups = file(GROUPS_FILE, FILE_IGNORE_NEW_LINES | FILE_SKIP_EMPTY_LINES);
            if (count($groups) == 0) {
                sendMessage($chat_id, "📭 لیست گروه‌ها خالی است.");
            } else {
                $out = "📋 لیست گروه‌های ثبت‌شده:\n\n";
                foreach ($groups as $i => $g) $out .= ($i + 1) . ". " . $g . "\n";
                sendMessage($chat_id, $out);
            }
        }
        break;

    case $text == '/startsend':
        file_put_contents(STATUS_FILE, "on");
        sendMessage($chat_id, "🚀 ارسال خودکار فعال شد.");
        break;

    case $text == '/stopsend':
        file_put_contents(STATUS_FILE, "off");
        sendMessage($chat_id, "🛑 ارسال خودکار متوقف شد.");
        break;

    case $text == '/status':
        $status = (file_exists(STATUS_FILE) && trim(file_get_contents(STATUS_FILE)) == 'on') ? "✅ فعال" : "⛔ غیرفعال";
        $msg_count = file_exists(MESSAGES_FILE) ? count(file(MESSAGES_FILE, FILE_IGNORE_NEW_LINES | FILE_SKIP_EMPTY_LINES)) : 0;
        $grp_count = file_exists(GROUPS_FILE) ? count(file(GROUPS_FILE, FILE_IGNORE_NEW_LINES | FILE_SKIP_EMPTY_LINES)) : 0;
        $pointer = file_exists(POINTER_FILE) ? intval(file_get_contents(POINTER_FILE)) : 0;

        $out = "📊 وضعیت ربات:\n\n";
        $out .= "وضعیت ارسال خودکار: $status\n";
        $out .= "تعداد پیام‌ها: $msg_count\n";
        $out .= "تعداد گروه‌ها: $grp_count\n";
        $out .= "شماره پیام فعلی: " . ($pointer + 1) . "\n";
        sendMessage($chat_id, $out);
        break;

    default:
        $help = "📚 دستورات ربات:\n\n";
        $help .= "/add [متن] ➕ افزودن پیام\n";
        $help .= "/list 📋 لیست پیام‌ها\n";
        $help .= "/del [شماره] ❌ حذف پیام\n";
        $help .= "/addgroup [group_id] ➕ افزودن گروه جدید\n";
        $help .= "/groups 📜 لیست گروه‌ها\n";
        $help .= "/startsend 🚀 شروع ارسال خودکار\n";
        $help .= "/stopsend 🛑 توقف ارسال خودکار\n";
        $help .= "/status 📊 نمایش وضعیت فعلی\n";
        sendMessage($chat_id, $help);
        break;
}
