<?php
header('Content-Type: application/json; charset=utf-8');
$bot_name = $_GET['bot'] ?? '';
$configPath = __DIR__ . '/config.json';
if (!file_exists($configPath)) {
    echo json_encode(['error'=>'no_config'], JSON_UNESCAPED_UNICODE); exit;
}
$config = json_decode(file_get_contents($configPath), true);
if (!isset($config['child_bots']) || !is_array($config['child_bots'])) {
    echo json_encode([], JSON_UNESCAPED_UNICODE); exit;
}
foreach ($config['child_bots'] as $child) {
    if (isset($child['bot_name']) && $child['bot_name'] === $bot_name) {
        $response = [
            'texts' => $config['texts'] ?? [],
            'default_reaction' => $config['default_reaction'] ?? '👍',
            'bot_status' => $config['bot_status'] ?? 'on',
            'mandatory_channels' => $config['mandatory_channels'] ?? []
        ];
        echo json_encode($response, JSON_UNESCAPED_UNICODE);
        exit;
    }
}
echo json_encode(['error'=>'not_found'], JSON_UNESCAPED_UNICODE);
exit;
?>