<?php
session_start();
$configPath = __DIR__ . '/../config.json';
$config = json_decode(file_get_contents($configPath), true);
if (empty($_SESSION['admin_id']) || !in_array($_SESSION['admin_id'], $config['admin_ids'])) {
    exit('دسترسی فقط برای ادمین مجاز است.');
}
$message = '';
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    if (isset($_POST['add_channel'])) {
        $ch = trim($_POST['channel']);
        if ($ch !== '' && !in_array($ch, $config['mandatory_channels'])) {
            $config['mandatory_channels'][] = $ch;
            file_put_contents($configPath, json_encode($config, JSON_PRETTY_PRINT|JSON_UNESCAPED_UNICODE));
            $message = "کانال $ch اضافه شد.";
        } else {
            $message = "کانال خالی یا قبلاً اضافه شده است.";
        }
    } elseif (isset($_POST['remove_channel'])) {
        $ch = trim($_POST['channel_to_remove']);
        $config['mandatory_channels'] = array_values(array_diff($config['mandatory_channels'], [$ch]));
        file_put_contents($configPath, json_encode($config, JSON_PRETTY_PRINT|JSON_UNESCAPED_UNICODE));
        $message = "کانال $ch حذف شد.";
    }
}
?>
<!doctype html><html lang="fa"><head><meta charset="utf-8"><title>کانال‌های اجباری</title></head>
<body style="direction:rtl;font-family:tahoma;padding:20px;">
<h2>مدیریت کانال‌های اجباری</h2>
<?php if($message) echo "<p style='color:green;'>$message</p>"; ?>
<h3>افزودن کانال اجباری</h3>
<form method="post">
    <label>نام یا یوزرنیم کانال (مثال: @mychannel یا -1001234567890)</label><br>
    <input type="text" name="channel" placeholder="@channel"><br><br>
    <button type="submit" name="add_channel">افزودن</button>
</form>
<h3>لیست کانال‌های اجباری</h3>
<ul>
<?php foreach ($config['mandatory_channels'] as $c) {
    echo "<li>$c
        <form style='display:inline' method='post'>
            <input type='hidden' name='channel_to_remove' value='".htmlspecialchars($c,ENT_QUOTES)."'>
            <button type='submit' name='remove_channel'>حذف</button>
        </form>
    </li>";
} ?>
</ul>
</body></html>
