<?php
// Child Bot with mandatory channel checks
$config_file = __DIR__ . '/config.json';
$config = json_decode(file_get_contents($config_file), true);
$token = $config['bot_token'] ?? '';
if (!$token) { exit("توکن ربات تنظیم نشده.\n"); }
$api = "https://api.telegram.org/bot{$token}/";

function sendMessage($chat_id, $text, $keyboard = null) {
    global $api;
    $data = ['chat_id' => $chat_id, 'text' => $text, 'parse_mode' => 'HTML'];
    if ($keyboard) $data['reply_markup'] = json_encode($keyboard,JSON_UNESCAPED_UNICODE);
    @file_get_contents($api . "sendMessage?" . http_build_query($data));
}

function masterFetch(&$config) {
    $master_api = rtrim($config['master_bot_api'], "/") . '?bot=' . urlencode($config['bot_name']);
    $resp = @file_get_contents($master_api);
    if ($resp) {
        $j = json_decode($resp, true);
        if (is_array($j)) {
            if (isset($j['texts'])) $config['texts'] = $j['texts'];
            if (isset($j['default_reaction'])) $config['default_reaction'] = $j['default_reaction'];
            if (isset($j['bot_status'])) $config['bot_status'] = $j['bot_status'];
            if (isset($j['mandatory_channels'])) $config['mandatory_channels'] = $j['mandatory_channels'];
        }
    }
    return $config;
}

function checkMandatoryChannels($user_id, $channels, $api) {
    if (empty($channels)) return true;
    foreach ($channels as $ch) {
        $chat_id = $ch;
        $url = $api . "getChatMember?chat_id=" . urlencode($chat_id) . "&user_id=" . urlencode($user_id);
        $resp = @file_get_contents($url);
        if (!$resp) return false;
        $j = json_decode($resp, true);
        if (!isset($j['ok']) || $j['ok'] !== true) return false;
        $status = $j['result']['status'] ?? '';
        if (in_array($status, ['left','kicked'])) return false;
    }
    return true;
}

function getUserMenu(){
    return [
        'keyboard'=>[
            [['text'=>'ثبت کانال و گروه برای ری‌اکشن رایگان']],
            [['text'=>'تنظیم ری‌اکشن'],['text'=>'حساب کاربری']],
            [['text'=>'راهنما'],['text'=>'پشتیبانی']],
            [['text'=>'ساخت ربات ری‌اکشن رایگان']]
        ],
        'resize_keyboard'=>true,'one_time_keyboard'=>false
    ];
}

$last_update_id = 0;
if (file_exists(__DIR__ . '/last_update_id.txt')) $last_update_id = (int)file_get_contents(__DIR__ . '/last_update_id.txt');

while (true) {
    // Update config from Master Bot
    $config = masterFetch($config);
    file_put_contents($config_file, json_encode($config, JSON_PRETTY_PRINT|JSON_UNESCAPED_UNICODE));

    if (isset($config['bot_status']) && $config['bot_status'] !== 'on') {
        sleep(5); continue;
    }

    $url = $api . "getUpdates?timeout=20&offset=" . ($last_update_id + 1);
    $resp = @file_get_contents($url);
    if (!$resp) { sleep(1); continue; }
    $data = json_decode($resp, true);
    if (!empty($data['result'])) {
        foreach ($data['result'] as $update) {
            $last_update_id = $update['update_id'];
            file_put_contents(__DIR__ . '/last_update_id.txt', $last_update_id);

            if (isset($update['message'])) {
                $chat_id = $update['message']['chat']['id'];
                $from_id = $update['message']['from']['id'];
                $text = $update['message']['text'] ?? '';

                $keyboard = getUserMenu();
                $mandatory = $config['mandatory_channels'] ?? [];
                $isMember = checkMandatoryChannels($from_id, $mandatory, $api);

                if (!$isMember) {
                    $msg = "لطفاً ابتدا عضو کانال‌های زیر شوید تا بتوانید از ربات استفاده کنید:\n\n";
                    foreach ($mandatory as $c) {
                        if (strpos($c, '@') === 0) {
                            $msg .= "• https://t.me/" . ltrim($c, '@') . "\n";
                        } else {
                            $msg .= "• " . $c . "\n";
                        }
                    }
                    $msg .= "\nپس از عضویت، یک پیام ارسال کنید تا وضعیت شما بررسی شود.";
                    sendMessage($chat_id, $msg, $keyboard);
                    continue;
                }

                switch ($text) {
                    case 'ثبت کانال و گروه برای ری‌اکشن رایگان':
                        sendMessage($chat_id, $config['texts']['register_text'] ?? 'لطفاً ربات را ادمین کانال کنید.', $keyboard);
                        break;
                    case 'تنظیم ری‌اکشن':
                        sendMessage($chat_id, "لطفا ری‌اکشن جدید را ارسال کنید.", $keyboard);
                        break;
                    case 'حساب کاربری':
                        $reaction_count = $config['reaction_count'] ?? 0;
                        $registered_count = count($config['registered_chats']);
                        $rank_text = "رتبه‌بندی کاربران:\n";
                        $top = $config['rank'] ?? [];
                        $i = 1;
                        foreach (array_slice($top, 0, 30) as $u) {
                            $rank_text .= "$i. {$u['name']} — {$u['reaction_count']} ری‌اکشن\n";
                            $i++;
                        }
                        sendMessage($chat_id, "تعداد کانال/گروه: $registered_count\nتعداد ری‌اکشن‌ها: $reaction_count\n\n$rank_text", $keyboard);
                        break;
                    case 'راهنما':
                        sendMessage($chat_id, $config['texts']['register_text'] ?? 'راهنما', $keyboard);
                        break;
                    case 'پشتیبانی':
                        $master_admins = $config['master_admins'] ?? [];
                        $support_msg = "پیام پشتیبانی از کاربر " . ($update['message']['from']['username'] ?? $from_id) . ":\n\n" . ($update['message']['text'] ?? '');
                        if (!empty($master_admins)) {
                            foreach ($master_admins as $adm) {
                                @file_get_contents($api . "sendMessage?chat_id=" . urlencode($adm) . "&text=" . urlencode($support_msg));
                            }
                        }
                        sendMessage($chat_id, $config['texts']['support_text'] ?? 'پیام شما به ادمین ارسال شد', $keyboard);
                        break;
                    case 'ساخت ربات ری‌اکشن رایگان':
                        sendMessage($chat_id, $config['texts']['create_bot_text'] ?? 'برای ساخت ربات، به Master Bot مراجعه کنید.', $keyboard);
                        break;
                    default:
                        sendMessage($chat_id, "لطفا گزینه‌ای از منو انتخاب کنید.", $keyboard);
                }
            }
        }
    }
}
?>